//
//  AppDelegate.swift
//  Orbis
//
//  Created by KALSI on 6/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import CoreData
import IQKeyboardManagerSwift
import MapKit
import UserNotifications
import CoreBluetooth
import Reachability



protocol ClassLocationDelegate {
    func getLocation(_ location: CLLocationCoordinate2D)
    func bgLocation(_ location: CLLocationCoordinate2D)
}



@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate , CLLocationManagerDelegate ,UNUserNotificationCenterDelegate,CBPeripheralDelegate,CBCentralManagerDelegate{
    
     var delegate: ClassLocationDelegate?
    var window: UIWindow?
    var locationArray = NSMutableArray()
    var userLocation = CLLocationCoordinate2D()
    var locmanager = CLLocationManager()
    
    var iPhnToken = ""
    var transVC = LoaderVW()

    var cManager = CBCentralManager()

    var isForeground = Bool()
    var isMovementTimer : Bool = false

    var fallscheduler = Timer()
    var blinker = Timer()

    var isFall : Bool = false
    var isMove : Bool = false

    var movescheduler = Timer()

    var isTimerProgress : Bool = false

    var backgroundAccess : Bool = false
    
    var isRedForAmber : Bool = false

    //bluetooth
    var isBluetooth : Bool = false
    var myDevice : CBPeripheral!
    var peripherals = NSMutableArray()
    var peripheralDevices = NSMutableArray()
    var noOfClcks : Int = 0
    var isRedActivated : Bool = false
    var willingtoReconnect : Bool = true
    var bluetoothTimer  = Timer()
    var retryCounts : Int = 0
    var retryConnection : Bool = false

    var myTimer  = Timer()


    //bluetooth^


    var messagePopup : Bool = true
    var isPUDSent : Bool = false

    
    var locTimer = Timer()
    var pudTimer = Timer()
    var tenSecTimer = Timer()

    var isPud : Bool = false

    var isAmberTimer = Bool()

    var totAmberSecs : Int = 0
    var saveAmberSecs : Int = 0


    //For No Movement
    var noMovTotSec = Int()
    var newnoMovTotSec = Int()
    
    var mins = Int()
    var hitValue = 1

    var secs = Int()
    var postDateTime = ""
    
    var interval : Int = 0
    var scheduler = Timer()
    
    var selectedViewController  = UIViewController()

    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplicationLaunchOptionsKey: Any]?) -> Bool {
        
       // print("24hoursformat---\(Date().toString(format:""))")
        
   
        appDelegate.cManager = CBCentralManager(delegate: self, queue: nil)

        
        UIApplication.shared.registerForRemoteNotifications()
        
        let center = UNUserNotificationCenter.current()
        center.delegate = self //DID NOT WORK WHEN self WAS MyOtherDelegateClass()
        
        center.requestAuthorization(options: [.alert, .sound, .badge]) {
            (granted, error) in
            // Enable or disable features based on authorization.
            if granted {
                // update application settings
            }
        }
        
        
        UNUserNotificationCenter.current().requestAuthorization(options:[.badge, .alert, .sound]){ (granted, error) in }
        application.registerForRemoteNotifications()
      
        
        UNUserNotificationCenter.current().requestAuthorization(options: [.badge, .alert, .sound]) {(accepted, error) in
            
            if !accepted {
                print("Notification access denied")
            }
        }
        
        IQKeyboardManager.sharedManager().enable = true
        UIDevice.current.isBatteryMonitoringEnabled = true
        
        
        
        if UserDefaults.standard.bool(forKey: "isLogged") == true {
            self.navigateToDashboard()
            }
        
        isForeground = true
        isAmberTimer = false

        appDelegate.isAmberTimer = true
        
//        locmanager.delegate = self
//        locmanager.desiredAccuracy = kCLLocationAccuracyBest
//        locmanager.requestAlwaysAuthorization()
//        locmanager.allowsBackgroundLocationUpdates = true
//        locmanager.startUpdatingLocation()

        
        
        locmanager = CLLocationManager()
        locmanager.delegate = self
        locmanager.desiredAccuracy = kCLLocationAccuracyBest
        locmanager.requestAlwaysAuthorization()
        locmanager.allowsBackgroundLocationUpdates = true
        locmanager.pausesLocationUpdatesAutomatically = false

        locmanager.startUpdatingLocation()
        let authstate = CLLocationManager.authorizationStatus()
        if(authstate == CLAuthorizationStatus.notDetermined){
            print("Not Authorised")
            locmanager.requestWhenInUseAuthorization()
        }
        
        
//        locTimer = Timer.scheduledTimer(withTimeInterval: 1, repeats: true) { (timer) in
//            self.isAmberTimer = false
//       self.startUpdatingLocation()
//        }
    UserDefaults.standard.set(true, forKey: "isSignalsAllowed")

        
        return true
    }
    
    func startPUD (){
//        pudTimer = Timer.scheduledTimer(withTimeInterval: TimeInterval(AppConfiguration.sharedInstance.positionUpdateInterval), repeats: true) { (timer) in
        
        
//        var timerValue = Int()
//        if !MyReachability.isConnectedToNetwork() {
//timerValue = 300
//
//        }else{
//            timerValue = AppConfiguration.sharedInstance.positionUpdateInterval
//
//        }
        
        pudTimer = Timer.scheduledTimer(withTimeInterval: TimeInterval(300), repeats: true) { (timer) in
            
          //  print(self.locmanager.location?.coordinate.latitude as Any
            //)
           // print(self.locmanager.location?.coordinate.longitude as Any)
            let alertView = UIAlertController(title: "", message: "\(self.locmanager.location?.coordinate.latitude,self.locmanager.location?.coordinate.longitude)", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: .default, handler: { (alert) in
                
            })
            alertView.addAction(action)
           // self.window?.rootViewController?.present(alertView, animated: true, completion: nil)

            
        if (!Globals().checkSignalsAuthorization()){
                
                return
            }
            let reachability = Reachability()!
            
            do{
                try reachability.startNotifier()
            }catch{
                print("could not start reachability notifier")
            }
            reachability.whenReachable = { reachability in
                if reachability.connection == .wifi {
                    print("Reachable via WiFi")
                    
                } else {
                    print("Reachable via Cellular")
                }
                print("loc in PUD")
                print(self.locmanager.location?.coordinate.latitude as Any)
                print(self.locmanager.location?.coordinate.longitude as Any)
                
                self.userLocation = (self.locmanager.location?.coordinate)!

               // self.delegate?.bgLocation(self.userLocation)

            }
            
        Globals().SetLocationDelegate()
            self.isPud = true
            self.isAmberTimer = false
                if UserDefaults.standard.object(forKey: "wantTraining") != nil {
                    print("PUDisready")
                    
                    
                    let updatesDictionary = ["date":String().fullFormatCurrentTime, "location":""] as [String : Any]
                    UserDefaults.standard.setValue(updatesDictionary, forKey: "locationOrb")
                    //UserDefaults.standard.synchronize()
                    
                    
                    self.delegate?.bgLocation(self.userLocation)
                    
                    
                
            }
      //    self.startUpdatingLocation()
        }
        
    }
    func getKillSignals() {

        
        print(killSignalsService)
        print(UserDefaults.standard.object(forKey: "userRefID")!)
        Globals.Services().AlamofireGetService(serviceURL: "\(killSignalsService)?ref=\(UserDefaults.standard.object(forKey: "userRefID")!)", completion: { (result) in
            print(result)
//            print("Recived: \(userInfo)")
          let myData = result["data"] as? NSDictionary
//            print("Recivedddddddaps: \(aps!)")
//            
           if myData?["signal_kill"] as! String ==  "signal on"{
                UserDefaults.standard.set(true, forKey: "isSignalsAllowed")
                
            }
            else{
                UserDefaults.standard.set(false, forKey: "isSignalsAllowed")
                
            }

            
        }) { (failure) in
            print(failure)
            
        }
        

    }
    
    func getAppConfigData() {

        
//        parameters = [
//            "ref":UserDefaults.standard.object(forKey: "userRefID") ?? 0
//                   ]
//print("\(baseURL)\(appConfigService)?ref=\(UserDefaults.standard.object(forKey: "userRefID")!)")
        
        //print("\(parameters)")
        
        
       // Globals.Services().AlamofireGetService(serviceURL: "\(appConfigService)?ref=\(UserDefaults.standard.object(forKey: "userRefID")!)", completion: { (result) in
            //print(result["data"]!)
           // AppConfiguration.sharedInstance.setConfigData(configData: result["data"]! as! NSDictionary)
            AppConfiguration.sharedInstance.setConfigData()

            self.startPUD()

//        }) { (failure) in
//            print(failure)
//
//        }
//
       

    }
    
    func navigateToDashboard() {
       // DispatchQueue.main.async { () -> Void in

        
      //  self.getKillSignals()

      self.getAppConfigData()

        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let eventDetailsVC = storyboard.instantiateViewController(withIdentifier: "TabController") as! TabController
        let navigationController = self.window?.rootViewController as! UINavigationController
        self.window?.viewWithTag(999)?.removeFromSuperview()
        navigationController.pushViewController(eventDetailsVC, animated: false)

   // AppConfiguration.sharedInstance.setConfigData()
        
        
        
    }
    
    func startUpdatingLocation(){
        //Set Location
        print("startUpdatingLocationamber-----")
        UIApplication.shared.beginBackgroundTask {
            
        }
        
        
        locmanager.delegate = self
        locmanager.desiredAccuracy = kCLLocationAccuracyBest
        locmanager.requestAlwaysAuthorization()
        locmanager.allowsBackgroundLocationUpdates = true
        locmanager.pausesLocationUpdatesAutomatically = false
        locmanager.startUpdatingLocation()
    }

    // MARK: updateLocationDelegates
    
    func locationManager(_ manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {

        userLocation = (locmanager.location?.coordinate)!
//        print("didUpdateLocationscalled")

//        if isAmberTimer {
//            print("isamertruecalled")
//          //  delegate?.getLocation((manager.location?.coordinate)!)
//            self.isAmberTimer = false
//
//        }else{
//           // self.delegate?.bgLocation(self.userLocation)
//
//        }
       
           // locmanager.stopUpdatingLocation()
        
            //locmanager.delegate = nil
            self.backgroundAccess = false
         
    }
    
    private func locationManager(manager: CLLocationManager, didFailWithError error: Error) {
        print("Couldn't get your location with \(error.localizedDescription)")
    }
    
    func applicationWillResignActive(_ application: UIApplication) {
        print("Orbis is resigned")
       // if !self.messagePopup{

        if UserDefaults.standard.bool(forKey: "code_red"){
            NotificationCenter.default.post(name: NSNotification.Name("stopViberating"), object: nil)
        }
        //}
        
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        
        isForeground = false
        appDelegate.isFall = false
        appDelegate.isMove = false
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        if self.myDevice != nil{
        if self.myDevice.state == .disconnected{
            //reconnectDeviceFromAlert()
            self.cManager.connect(self.myDevice, options: nil)

            }}
        
        isForeground = true
        locTimer.invalidate()
        if UserDefaults.standard.bool(forKey: "code_red") {
            Timer.scheduledTimer(withTimeInterval: 1, repeats: false, block: { (Timer) in
                NotificationCenter.default.post(name: NSNotification.Name("CallRed"), object: nil)
            })
        }
        
        if self.isFall || self.isMove{
            Globals().anotherNo()
        }
        
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        //if !self.messagePopup{
        if UserDefaults.standard.bool(forKey: "code_red") {
            NotificationCenter.default.post(name: NSNotification.Name("startViberating"), object: nil)
        }
       // }
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }
    
    func applicationWillTerminate(_ application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
        // Saves changes in the application's managed object context before the application terminates.
        self.saveContext()
        print("i am terminate")
        
        if UserDefaults.standard.bool(forKey: "isLogged") == true {
            let vc = UIViewController()
            Globals().SendSignalToARC(controllerObject:vc , signalType: Constants.sTerminate)
        }
    }

    // MARK: - Core Data stack

    lazy var persistentContainer: NSPersistentContainer = {
        /*
         The persistent container for the application. This implementation
         creates and returns a container, having loaded the store for the
         application to it. This property is optional since there are legitimate
         error conditions that could cause the creation of the store to fail.
        */
        let container = NSPersistentContainer(name: "Orbis")
        container.loadPersistentStores(completionHandler: { (storeDescription, error) in
            if let error = error as NSError? {
                // Replace this implementation with code to handle the error appropriately.
                // fatalError() causes the application to generate a crash log and terminate. You should not use this function in a shipping application, although it may be useful during development.
                 
                /*
                 Typical reasons for an error here include:
                 * The parent directory does not exist, cannot be created, or disallows writing.
                 * The persistent store is not accessible, due to permissions or data protection when the device is locked.
                 * The device is out of space.
                 * The store could not be migrated to the current model version.
                 Check the error message to determine what the actual problem was.
                 */
                fatalError("Unresolved error \(error), \(error.userInfo)")
            }
        })
        return container
    }()

    // MARK: - Core Data Saving support

    func saveContext () {
        let context = persistentContainer.viewContext
        if context.hasChanges {
            do {
                try context.save()
            } catch {
                // Replace this implementation with code to handle the error appropriately.
                // fatalError() causes the application to generate a crash log and terminate. You should not use this function in a shipping application, although it may be useful during development.
                let nserror = error as NSError
                fatalError("Unresolved error \(nserror), \(nserror.userInfo)")
            }
        }
    }
    
    //MARK: RemoteNotification
    
     func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Swift.Void)
 {
        completionHandler( [.alert, .badge, .sound])
        
        print("presentLocalNotfctn")

    }
    func userNotificationCenter(_ center: UNUserNotificationCenter, didReceive response: UNNotificationResponse, withCompletionHandler completionHandler: @escaping () -> Swift.Void){
        print("didReceive")

    }
    
//     func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Swift.Void) {
//
//        completionHandler( [.alert, .badge, .sound])
//
//        print("presentLocalNotfctn")
//    }
//
     private func application(application: UIApplication,  didReceiveLocalNotification userInfo: [NSObject : AnyObject],  fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
        
        print("Recived: \(userInfo)")
        
        completionHandler(.newData)
        
    }

    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Swift.Void){
        print("Recived: \(userInfo)")
let aps = userInfo["aps"] as? NSDictionary
        print("Recivedddddddaps: \(aps!)")
        
        if aps?["alert"] as! String ==  "Signal Allowed"{
            UserDefaults.standard.set(true, forKey: "isSignalsAllowed")

        }
        else{
            UserDefaults.standard.set(false, forKey: "isSignalsAllowed")

        }
    }
    
//    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
//        if let aps = userInfo["aps"] as? NSDictionary {
//            print(aps)
//          //  let alert = (aps.object(forKey: "alert") as? String)!
//        }
//        
//        
//    }
    
    func application(_ application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data) {
        // Convert token to string
        let deviceTokenString = deviceToken.reduce("", {$0 + String(format: "%02X", $1)})
        
        // Print it to console
        print("APNs device token: \(deviceTokenString)")
        iPhnToken = deviceTokenString
        
        let alertView = UIAlertController(title: "", message: deviceTokenString, preferredStyle: .alert)
        let action = UIAlertAction(title: "OK", style: .default, handler: { (alert) in
            
        })
        alertView.addAction(action)
       // self.window?.rootViewController?.present(alertView, animated: true, completion: nil)

        // DF279E65798F9202273A28793F494FE1CEB713A9B2E507C9C511592CE09A6E80
        // Persist it in your backend in case it's new
    }
    
    // Called when APNs failed to register the device for push notifications
    func application(_ application: UIApplication, didFailToRegisterForRemoteNotificationsWithError error: Error) {
        // Print the error to console (you should alert the user that registration failed)
        print("APNs registration failed: \(error)")
    }
    
    
    
    
    
    
    
    

    
    
    //MARK: Bluetooth delegates
    
    func centralManagerDidUpdateState(_ central: CBCentralManager){
        appDelegate.cManager.scanForPeripherals(withServices:[CBUUID.init(string: "1802")], options: nil)
        
    }
    
    // MARK: - CBCentralManagerDelegate Methods
    func centralManager(_ central: CBCentralManager, didDiscover peripheral: CBPeripheral, advertisementData: [String : Any], rssi RSSI: NSNumber)
    {
        
                let service = peripheral.services as? CBService
     //   peripheral.setNotifyValue(true, for: service?.characteristics as! CBCharacteristic)
        
        peripheral.delegate = self
        
        let peripheralName = peripheral.name
        if peripheralName != nil{
        if !peripherals.contains(peripheralName!){
            peripherals.add(peripheralName!)
            peripheralDevices.add(peripheral)
        }
        //        if(!peripherals.contains(peripheral)) {
        //            peripherals.append(peripheral)
        //        }
        //
      //  self.peripheralsList.reloadData()
        
      //  appDelegate.cManager.stopScan()
       // peripheral.delegate = self
        peripheral.discoverServices(nil)
        }

        //  self.cManager.connect(peripheral, options: nil)
        
    }
    
    func centralManager(_ central: CBCentralManager, didConnect peripheral: CBPeripheral) {
        myTimer.invalidate()
        print("VALT connected")
       // peripheral.delegate = self
        peripheral.discoverServices(nil)
        //appDelegate.cManager.stopScan()

        //pass reference to connected peripheral to parent view
        //        parentView?.mainPeripheral = peripheral
        //        peripheral.delegate = parentView
        //        peripheral.discoverServices(nil)
        //
        //        //set the manager's delegate view to parent so it can call relevant disconnect methods
        //        manager?.delegate = parentView
        //        parentView?.customiseNavigationBar()
        //
        //
        //        print("Connected to " +  peripheral.name!)
        appDelegate.willingtoReconnect = true
        retryConnection = false
        let index = peripherals.index(of: peripheral.name!)
        
        peripherals.replaceObject(at: index, with: "\(peripheral.name!) - Connected")
        NotificationCenter.default.post(name: NSNotification.Name("reloadList"), object: nil)

//        self.peripheralsList.reloadData()
        
    }
    
    
    
    func peripheral(_ peripheral: CBPeripheral, didDiscoverServices error: Error?){
        peripheral.discoverServices([CBUUID.init(string: "1802")])
        
        
        if let services = peripheral.services {
            for service in services {
                
                peripheral.discoverCharacteristics(nil, for: service)
            }
        }
    }
    
    func reconnectDeviceFromAlert()  {
        let alertView = UIAlertController(title: "Sorry!", message: "Your bluetooth device \(myDevice.name!) is not connected.", preferredStyle: .alert)
        let yesAction = UIAlertAction(title: "Ok", style: .default, handler: { (alert) in
//            appDelegate.willingtoReconnect = true
//
//            self.cManager.connect(self.myDevice, options: nil)
            
        })
        alertView.addAction(yesAction)
//        let noAction = UIAlertAction(title: "No", style: .default, handler: { (alert) in
//            self.willingtoReconnect = false
//        })
//        alertView.addAction(noAction)
        
        
        self.window?.rootViewController?.present(alertView, animated: true, completion: nil)
        

    }
    
    func centralManager(_ central: CBCentralManager, didDisconnectPeripheral peripheral: CBPeripheral, error: Error?){
        
        
      

        let index = peripherals.index(of: "\(peripheral.name!) - Connected")
        peripherals.replaceObject(at: index, with: "\(peripheral.name!)")
      //  self.peripheralsList.reloadData()
        NotificationCenter.default.post(name: NSNotification.Name("reloadList"), object: nil)

       
        
        if(UIApplication.shared.applicationState ==
            .active)
        {

            //App is in foreground. Act on it.
            if willingtoReconnect{
                self.cManager.connect(self.myDevice, options: nil)

//            self.reconnectDeviceFromAlert()
            }

        }else{
//            Globals().createNotification(title: "Sorry!", message: "Bluetooth device disconnected!")
            if willingtoReconnect{
                self.cManager.connect(self.myDevice, options: nil)
                
                // self.reconnectDeviceFromAlert()
            }
        }
        
       
        
//        if self.myDevice.state == .connected{
//
//        }
//
//        if self.myDevice.state == .connecting{
//            Timer.scheduledTimer(withTimeInterval: 0.1, repeats: true, block: { (myTimer) in
//                self.retryCounts = self.retryCounts + 1
//                if self.retryCounts == 60{
//                    Globals().createNotification(title: "Sorry!", message: "Bluetooth device disconnected!")
//                    self.reconnectDeviceFromAlert()
//                    myTimer.invalidate()
//
//                }else{
//                    //self.cManager.connect(self.myDevice, options: nil)
//                    appDelegate.cManager = CBCentralManager(delegate: self, queue: nil)
//
//                }
//
//            })
////            Globals().createNotification(title: "Sorry!", message: "Bluetooth device disconnected!")
////            self.reconnectDeviceFromAlert()
//        }
        switch self.myDevice.state {
        case .connected:
            break
        case .connecting:
            print("retrying")
            if !retryConnection {
             myTimer = Timer.scheduledTimer(withTimeInterval: 60, repeats: true, block: { (timer) in
                    //if self.retryCounts == 60{
                    Globals().createNotification(title: "Sorry!", message: "Bluetooth device disconnected!")
                    self.reconnectDeviceFromAlert()
                    timer.invalidate()
                    
                    //}else{
                    //self.cManager.connect(self.myDevice, options: nil)
                    //  appDelegate.cManager = CBCentralManager(delegate: self, queue: nil)
                    
                    //}
                    self.retryConnection = true
                    
                })
                break
            }
        case .disconnected:
            break
        case .disconnecting:
            break
        }
        
    }
    
    func peripheral(_ peripheral: CBPeripheral, didDiscoverCharacteristicsFor service: CBService, error: Error?){
        
        // let myID = CBUUID.init(string: "fffffff2-00f7-4000-b000-000000000000")
        for aChar in service.characteristics! {
            
            // if (aChar.uuid == myID){
            peripheral.setNotifyValue(true, for: aChar)
            
            // }
            
        }
        
    }
    func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?){
        print("didUpdateValueFor clicks")

        print("noOfClcks\(self.noOfClcks)")

      //  if willingtoReconnect{
        if !appDelegate.isRedActivated{
        noOfClcks =  noOfClcks + 1
            bluetoothTimer.invalidate()
    bluetoothTimer =   Timer.scheduledTimer(withTimeInterval: 10, repeats: false) { (timer) in
            self.noOfClcks = 0
            }}
            
            
        if noOfClcks == 10 {
            
            //  let storyboard = UIStoryboard(name: "Main", bundle: nil)
            //   let dashController = storyboard.instantiateViewController(withIdentifier: "RedAlert") as! RedAlert
            //print(self.navigationController?.viewControllers)
            // self.navigationController?.pushViewController(dashController, animated: false)
            
            //            for vc in (self.navigationController?.viewControllers ?? []) {
            //                if vc == dashController{
            // self.navigationController?.popToViewController(dashController, animated: true)
            
            //                }
            //            }
            
            
            //                           DispatchQueue.main.async {
            //      _ = self.navigationController?.popToViewController(dashController, animated: false)
            //        }
            appDelegate.isBluetooth = true
        //    self.navigationController?.popViewController(animated: false)
            NotificationCenter.default.post(name: NSNotification.Name("navigater"), object: nil)

            NotificationCenter.default.post(name: NSNotification.Name("tabShift"), object: 3)
            
            appDelegate.isRedActivated = true
            self.noOfClcks = 0

        }
       // }
    }
    
    func peripheral(_ peripheral: CBPeripheral, didModifyServices invalidatedServices: [CBService]){
        print("didModifyServices clicks")
        
    }
    
    func centralManager(_ central: CBCentralManager, didFailToConnect peripheral: CBPeripheral, error: Error?){
        //    print(error?.localizedDescription)
    }

}


